package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class AddPayoutViewModel(
    private val context: Context,
    private val walletRepository: WalletRepository
):ViewModel() {
    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences= Functions.getSharedPreference(context)
    }
    val _addPayoutLiveData: MutableLiveData<ApiResponce<ArrayList<UserModel>>> = MutableLiveData()
    val payoutLiveData: LiveData<ApiResponce<ArrayList<UserModel>>> get() = _addPayoutLiveData

    fun addPayout(type: String, email: String){
        viewModelScope.launch {
            val params = JSONObject()
            params.put("value", email)
            params.put("type", type)

            walletRepository.addPayout(params,_addPayoutLiveData)
        }
    }
}

class AddPayoutFactory(
    private val context: Context,
    private val walletRepository: WalletRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(AddPayoutViewModel::class.java)) {
            return AddPayoutViewModel(context, walletRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}